<?php

namespace App\Filament\Resources\EntryResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use App\Models\Tag;
use Illuminate\Database\Eloquent\Relations\Relation;

class TagsRelationManager extends RelationManager
{
    protected static string $relationship = 'tags';

    protected function getTableQuery(): Builder | Relation | null
    {
        return Tag::query()->whereIn((new Tag())->getKeyName(), $this->ownerRecord->tag_ids ?? []);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('title')
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('title')
            ->columns([
                Tables\Columns\TextColumn::make('title'), //->getStateUsing(fn ($record) => Tag::find($record->id)->title),
            ]);
//            ->headerActions([
//                Tables\Actions\AttachAction::make()->preloadRecordSelect()->recordSelectSearchColumns(['title']),
//            ]);
//            ->actions([
//                Tables\Actions\DetachAction::make()->action(function ($record, $livewire) {
//                    $entry = $livewire->ownerRecord;
//                    $entry->pull('tag_ids', $record->_id);
//                }),
//            ]);
//            ->bulkActions([
//                Tables\Actions\BulkActionGroup::make([
//                    Tables\Actions\DetachBulkAction::make(),
//                ]),
//            ]);
    }
}
